/*
 * Decompiled with CFR 0.152.
 */
package com.tom.storagemod.block;

import com.tom.storagemod.block.IInventoryCable;
import com.tom.storagemod.proxy.ClientProxy;
import com.tom.storagemod.tile.TileEntityLevelEmitter;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.ContainerBlock;
import net.minecraft.block.material.Material;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.RedstoneParticleData;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ToolType;

public class BlockLevelEmitter
extends ContainerBlock
implements IInventoryCable {
    public static final DirectionProperty FACING = BlockStateProperties.field_208155_H;
    public static final BooleanProperty POWERED = BlockStateProperties.field_208194_u;

    public BlockLevelEmitter() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151575_d).func_200943_b(3.0f).func_226896_b_().harvestTool(ToolType.AXE));
        this.setRegistryName("ts.level_emitter");
        this.func_180632_j((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)Direction.DOWN)).func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_190948_a(ItemStack stack, IBlockReader worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        ClientProxy.tooltip("level_emitter", tooltip);
    }

    public TileEntity func_196283_a_(IBlockReader worldIn) {
        return new TileEntityLevelEmitter();
    }

    public boolean func_149744_f(BlockState state) {
        return true;
    }

    public int func_176211_b(BlockState blockState, IBlockReader blockAccess, BlockPos pos, Direction side) {
        if (!((Boolean)blockState.func_177229_b((Property)POWERED)).booleanValue()) {
            return 0;
        }
        return ((Direction)blockState.func_177229_b((Property)FACING)).func_176734_d() == side ? 15 : 0;
    }

    public int func_180656_a(BlockState blockState, IBlockReader blockAccess, BlockPos pos, Direction side) {
        if (!((Boolean)blockState.func_177229_b((Property)POWERED)).booleanValue()) {
            return 0;
        }
        return 15;
    }

    public boolean canConnectRedstone(BlockState state, IBlockReader world, BlockPos pos, Direction side) {
        return state.func_177229_b((Property)FACING) != side;
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((Property)FACING, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((Property)FACING)));
    }

    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((Direction)state.func_177229_b((Property)FACING)));
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)context.func_196000_l());
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING, POWERED});
    }

    public BlockRenderType func_149645_b(BlockState p_149645_1_) {
        return BlockRenderType.MODEL;
    }

    @Override
    public List<BlockPos> next(World world, BlockState state, BlockPos pos) {
        return Collections.emptyList();
    }

    @Override
    public boolean canConnectFrom(BlockState state, Direction dir) {
        return ((Direction)state.func_177229_b((Property)FACING)).func_176734_d() == dir;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        switch ((Direction)state.func_177229_b((Property)FACING)) {
            case DOWN: {
                return VoxelShapes.func_197872_a((VoxelShape)BlockLevelEmitter.func_208617_a((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)6.0, (double)11.0), (VoxelShape)BlockLevelEmitter.func_208617_a((double)3.0, (double)6.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0));
            }
            case EAST: {
                return VoxelShapes.func_197872_a((VoxelShape)BlockLevelEmitter.func_208617_a((double)10.0, (double)5.0, (double)5.0, (double)16.0, (double)11.0, (double)11.0), (VoxelShape)BlockLevelEmitter.func_208617_a((double)0.0, (double)3.0, (double)3.0, (double)10.0, (double)13.0, (double)13.0));
            }
            case NORTH: {
                return VoxelShapes.func_197872_a((VoxelShape)BlockLevelEmitter.func_208617_a((double)5.0, (double)5.0, (double)0.0, (double)11.0, (double)11.0, (double)6.0), (VoxelShape)BlockLevelEmitter.func_208617_a((double)3.0, (double)3.0, (double)6.0, (double)13.0, (double)13.0, (double)16.0));
            }
            case SOUTH: {
                return VoxelShapes.func_197872_a((VoxelShape)BlockLevelEmitter.func_208617_a((double)5.0, (double)5.0, (double)10.0, (double)11.0, (double)11.0, (double)16.0), (VoxelShape)BlockLevelEmitter.func_208617_a((double)3.0, (double)3.0, (double)0.0, (double)13.0, (double)13.0, (double)10.0));
            }
            case UP: {
                return VoxelShapes.func_197872_a((VoxelShape)BlockLevelEmitter.func_208617_a((double)5.0, (double)10.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0), (VoxelShape)BlockLevelEmitter.func_208617_a((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)10.0, (double)13.0));
            }
            case WEST: {
                return VoxelShapes.func_197872_a((VoxelShape)BlockLevelEmitter.func_208617_a((double)0.0, (double)5.0, (double)5.0, (double)6.0, (double)11.0, (double)11.0), (VoxelShape)BlockLevelEmitter.func_208617_a((double)6.0, (double)3.0, (double)3.0, (double)16.0, (double)13.0, (double)13.0));
            }
        }
        return VoxelShapes.func_197868_b();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        if (((Boolean)stateIn.func_177229_b((Property)POWERED)).booleanValue()) {
            Direction direction = ((Direction)stateIn.func_177229_b((Property)FACING)).func_176734_d();
            double d0 = (double)pos.func_177958_n() + 0.5 + (rand.nextDouble() - 0.5) * 0.2;
            double d1 = (double)pos.func_177956_o() + 0.5 + (rand.nextDouble() - 0.5) * 0.2;
            double d2 = (double)pos.func_177952_p() + 0.5 + (rand.nextDouble() - 0.5) * 0.2;
            float f = -7.0f;
            double d3 = (f /= 16.0f) * (float)direction.func_82601_c();
            double d4 = f * (float)direction.func_82599_e();
            worldIn.func_195594_a((IParticleData)RedstoneParticleData.field_197564_a, d0 + d3, d1, d2 + d4, 0.0, 0.0, 0.0);
        }
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult rtr) {
        if (world.field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        TileEntity blockEntity_1 = world.func_175625_s(pos);
        if (blockEntity_1 instanceof TileEntityLevelEmitter) {
            player.func_213829_a((INamedContainerProvider)((TileEntityLevelEmitter)blockEntity_1));
        }
        return ActionResultType.SUCCESS;
    }
}

